# [SelectorQuery](SelectorQuery.html) NodesRef.context(function callback)

添加节点的 Context 对象查询请求。目前支持 [VideoContext](../media/video/VideoContext.html)、[CanvasContext](../canvas/CanvasContext.html)、 和 [MapContext](../media/map/MapContext.html) 的获取。

## 参数

### function callback

回调函数，在执行 `SelectorQuery.exec` 方法后，返回节点信息。

#### 参数

##### Object res

| 属性    | 类型   | 说明                    |
| ------- | ------ | ----------------------- |
| context | Object | 节点对应的 Context 对象 |

## 返回值

### [SelectorQuery](SelectorQuery.html)

## 示例代码

```js
Page({
  getContext() {
    qa.createSelectorQuery()
      .select('.the-video-class')
      .context(function(res) {
        console.log(res.context) // 节点对应的 Context 对象。如：选中的节点是 <video> 组件，那么此处即返回 VideoContext 对象
      })
      .exec()
  }
})
```
