# IntersectionObserver.relativeToViewport(Object margins)

指定页面显示区域作为参照区域之一

## 参数

### Object margins

用来扩展（或收缩）参照节点布局区域的边界

| 属性   | 类型   | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明                 |
| ------ | ------ | ------------------------------------- | ----------------------------------- | -------------------- |
| left   | number |                                       | 否                                  | 节点布局区域的左边界 |
| right  | number |                                       | 否                                  | 节点布局区域的右边界 |
| top    | number |                                       | 否                                  | 节点布局区域的上边界 |
| bottom | number |                                       | 否                                  | 节点布局区域的下边界 |

## 示例代码

下面的示例代码中，如果目标节点（用选择器 .target-class 指定）进入显示区域以下 100px 时，就会触发回调函数。

```js
Page({
  onLoad: function() {
    qa.createIntersectionObserver()
      .relativeToViewport({ bottom: 100 })
      .observe('.target-class', res => {
        res.intersectionRatio // 相交区域占目标节点的布局区域的比例
        res.intersectionRect // 相交区域
        res.intersectionRect.left // 相交区域的左边界坐标
        res.intersectionRect.top // 相交区域的上边界坐标
        res.intersectionRect.width // 相交区域的宽度
        res.intersectionRect.height // 相交区域的高度
      })
  }
})
```
