# qa.login(Object object)

调用接口获取登录凭证（code）。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| success | function |  | 否 | 接口调用成功的回调函数 |  |
| fail | function |  | 否 | 接口调用失败的回调函数 |  |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |  |

#### object.success 回调函数

##### 参数

###### Object res

| 属性 | 类型   | 说明                           |
| ---- | ------ | ------------------------------ |
| code | string | 用户登录凭证（有效期五分钟）。 |

## 示例代码

```js
qa.login({
  success(res) {
    if (res.code) {
      //发起网络请求
      qa.request({
        url: 'https://test.com/onLogin',
        data: {
          code: res.code
        }
      })
    } else {
      console.log('登录失败！' + res.errMsg)
    }
  }
})
```
