# RecorderManager

全局唯一的录音管理器实例

## 方法

### [RecorderManager.start(Object object)](RecorderManager.start.html)

开始录音

### [RecorderManager.pause()](RecorderManager.pause.html)

暂停录音

### [RecorderManager.resume()](RecorderManager.resume.html)

继续录音

### [RecorderManager.stop()](RecorderManager.stop.html)

停止录音

### [RecorderManager.onStart(function callback)](./RecorderManager.onStart.html)

订阅 录音开始事件 回调

### [RecorderManager.onResume(function callback)](./RecorderManager.onResume.html)

订阅 录音继续事件 回调（只支持 Android 7.0 及以上设备）

### [RecorderManager.onPause(function callback)](./RecorderManager.onPause.html)

订阅 录音暂停事件 回调（只支持 Android 7.0 及以上设备）

### [RecorderManager.onStop(function callback)](./RecorderManager.onStop.html)

订阅 录音结束事件 回调

### [RecorderManager.onError(function callback)](./RecorderManager.onError.html)

订阅 录音错误事件 回调

## 示例代码

```js
const recorderManager = qa.getRecorderManager()

recorderManager.onStart(() => {
  console.log('recorder start')
})
recorderManager.onPause(() => {
  console.log('recorder pause')
})
recorderManager.onStop(res => {
  console.log('recorder stop', res)
  const { tempFilePath } = res
})

const options = {
  duration: 10000,
  sampleRate: 44100,
  numberOfChannels: 1,
  encodeBitRate: 192000,
  format: 'aac'
}

recorderManager.start(options)
```
