# InnerAudioContext

InnerAudioContext 实例

可以通过 [qa.createInnerAudioContext](qa.createInnerAudioContext.html) 接口创建实例。

## 属性

### string src

用于播放的音频资源地址

### number startTime	

开始播放的位置（单位：s），默认为 0

### boolean autoplay

是否自动播放，默认为 `false`

### boolean loop

是否循环播放，默认为 `false`

### number volume

播放音频的音量。范围 0~1。默认是 1

### number duration

当前音频资源的长度（单位 s）。只读属性，只在当前有合法的 src 时能返回

### number currentTime

当前音频的播放位置（单位 s）。只读属性，只有在当前有合法的 src 时返回

### boolean paused

当前是否暂停或停止状态（只读）

## 方法

### [InnerAudioContext.play()](InnerAudioContext.play.html)

播放音频

### [InnerAudioContext.pause()](InnerAudioContext.pause.html)

暂停播放音频，此时重新播放会从暂停处开始播放

### [InnerAudioContext.stop()](InnerAudioContext.stop.html)

停止播放音频，停止之后的重新播放会从头开始播放

### [InnerAudioContext.seek(number position)](InnerAudioContext.seek.html)

跳转到该音频的指定位置

### [InnerAudioContext.destroy()](InnerAudioContext.destroy.html)

销毁当前InnerAudioContext实例

### [InnerAudioContext.onCanplay(function callback)](./InnerAudioContext.onCanplay.html)

订阅**音频进入可以播放状态事件**回调，不能保证后续可以流畅播放

### [InnerAudioContext.offCanplay(function callback)](./InnerAudioContext.offCanplay.html)

取消订阅**音频进入可以播放状态事件**

### [InnerAudioContext.onPlay(function callback)](./InnerAudioContext.onPlay.html)

订阅**音频播放事件**回调

### [InnerAudioContext.offPlay(function callback)](./InnerAudioContext.offPlay.html)

取消订阅**音频播放事件**

### [InnerAudioContext.onPause(function callback)](./InnerAudioContext.onPause.html)

订阅**音频暂停事件**回调

### [InnerAudioContext.offPause(function callback)](./InnerAudioContext.offPause.html)

取消订阅**音频暂停事件**

### [InnerAudioContext.onStop(function callback)](./InnerAudioContext.onStop.html)

订阅**音频停止事件**回调

### [InnerAudioContext.offStop(function callback)](./InnerAudioContext.offStop.html)

取消订阅**音频停止事件**

### [InnerAudioContext.onEnded(function callback)](./InnerAudioContext.onEnded.html)

订阅**音频自然播放至结束的事件**回调

### [InnerAudioContext.offEnded(function callback)](./InnerAudioContext.offEnded.html)

取消订阅**音频自然播放至结束的事件**

### [InnerAudioContext.onTimeUpdate(function callback)](./InnerAudioContext.onTimeUpdate.html)

订阅**音频播放进度更新事件**回调

### [InnerAudioContext.offTimeUpdate(function callback)](./InnerAudioContext.offTimeUpdate.html)

取消订阅**音频播放进度更新事件**

### [InnerAudioContext.onError(function callback)](./InnerAudioContext.onError.html)

订阅**音频播放错误事件**回调

### [InnerAudioContext.offError(function callback)](./InnerAudioContext.offError.html)

取消订阅**音频播放错误事件**

### [InnerAudioContext.onWaiting(function callback)](./InnerAudioContext.onWaiting.html)

订阅**音频加载中事件**回调，当音频源因数据不足，需要停下来加载时会触发回调

### [InnerAudioContext.offWaiting(function callback)](./InnerAudioContext.offWaiting.html)

取消订阅**音频加载中事件**

### [InnerAudioContext.onSeeking(function callback)](./InnerAudioContext.onSeeking.html)

订阅**音频进行跳转操作的事件**回调

### [InnerAudioContext.offSeeking(function callback)](./InnerAudioContext.offSeeking.html)

取消订阅**音频进行跳转操作的事件**

### [InnerAudioContext.onSeeked(function callback)](./InnerAudioContext.onSeeked.html)

订阅**音频完成跳转操作的事件**回调

### [InnerAudioContext.offSeeked(function callback)](./InnerAudioContext.offSeeked.html)

取消订阅**音频完成跳转操作的事件**

## 支持格式

| 格式 | Android |
| ---- | ------- |
| flac | √       |
| m4a  | √       |
| ogg  | √       |
| ape  | √       |
| amr  | √       |
| wma  | √       |
| wav  | √       |
| mp3  | √       |
| mp4  | √       |
| aac  | √       |
| aiff | x       |
| caf  | x       |

## 示例代码

```js
const innerAudioContext = qa.createInnerAudioContext()
innerAudioContext.autoplay = true
innerAudioContext.src = 'http://xxx.quickapp.cn' // 示例地址，不存在该地址的真实音频
innerAudioContext.onPlay(() => {
  console.log('开始播放')
})
innerAudioContext.onError(res => {
  console.log(res.errMsg)
  console.log(res.errCode)
})
```
