 # qa.chooseImage(Object object)

从本地相册选择图片或打开系统相机拍照。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| count | number | 9 | 否 | 最多可以选择的图片张数 |
| sizeType | Array.\<string> | \['original', 'compressed'\] | 否 | 所选的图片的尺寸 |
| sourceType | Array.\<string> | \['album', 'camera'\] | 否 | 选择图片的来源 |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

**object.sizeType 的合法值**

| 值         | 说明   |
| ---------- | ------ |
| original   | 原图   |  |
| compressed | 压缩图 |  |

**object.sourceType 的合法值**

| 值     | 说明       |
| ------ | ---------- |
| album  | 从相册选图 |  |
| camera | 使用相机   |  |

#### object.success 回调函数

##### 参数

###### Object res

| 属性          | 类型            | 说明                       |
| ------------- | --------------- | -------------------------- |
| tempFilePaths | Array.\<string> | 图片的本地临时文件路径列表 |  |
| tempFiles     | Array.\<Object> | 图片的本地临时文件列表     |  |

**res.tempFiles 的结构**

| 属性 | 类型   | 说明                     |
| ---- | ------ | ------------------------ |
| path | string | 本地临时文件路径         |
| size | number | 本地临时文件大小，单位 B |

```js
qa.chooseImage({
  count: 1,
  sizeType: ['original', 'compressed'],
  sourceType: ['album', 'camera'],
  success(res) {
    // tempFilePath可以作为img标签的src属性显示图片
    const tempFilePaths = res.tempFilePaths
  }
})
```
