# qa.getBackgroundAudioPlayerState(Object object)

获取后台音乐播放状态。

## 参数

### Object object

| 属性 | 类型 | <div style="width: 50px">默认值</div> | <div style="width: 50px">必填</div> | 说明 |
| --- | --- | --- | --- | --- |
| success | function |  | 否 | 接口调用成功的回调函数 |
| fail | function |  | 否 | 接口调用失败的回调函数 |
| complete | function |  | 否 | 接口调用结束的回调函数（调用成功、失败都会执行） |

#### object.success 回调函数

##### 参数

###### Object res

| 属性            | 类型   | 说明                                                  |
| --------------- | ------ | ----------------------------------------------------- |
| duration        | number | 选定音频的长度（单位：s），只有在音乐播放中时返回     |
| currentPosition | number | 选定音频的播放位置（单位：s），只有在音乐播放中时返回 |
| status          | number | 播放状态                                              |
| dataUrl         | string | 歌曲数据链接，只有在音乐播放中时返回                  |

**res.status 的合法值**

| 值  | 说明         |
| --- | ------------ |
| 0   | 暂停中       |  |
| 1   | 播放中       |  |
| 2   | 没有音乐播放 |  |

## 示例代码

```js
qa.getBackgroundAudioPlayerState({
  success(res) {
    const status = res.status
    const dataUrl = res.dataUrl
    const currentPosition = res.currentPosition
    const duration = res.duration
  }
})
```
