# BackgroundAudioManager

BackgroundAudioManager 实例，可通过 [qa.getBackgroundAudioManager](qa.getBackgroundAudioManager.html) 获取。

## 属性

### string src

默认为空字符串，**当设置了新的 src 时，会自动开始播放**，目前支持的格式有 m4a, aac, mp3, wav。

### number startTime

音频开始播放的位置（单位：s）。

### string title

音频标题，用于原生音频播放器音频标题（必填）。原生音频播放器中的分享功能，分享出去的卡片标题，也将使用该值。

### string epname

专辑名，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。

### string singer

歌手名，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。

### string coverImgUrl

封面图 URL，用于做原生音频播放器背景图。原生音频播放器中的分享功能，分享出去的卡片配图及背景也将使用该图。

### string webUrl

页面链接，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。

### string protocol

音频协议。默认值为 'http'，设置 'hls' 可以支持播放 HLS 协议的直播音频。

### number duration

当前音频的长度（单位：s），只有在有合法 src 时返回。（只读）

### number currentTime

当前音频的播放位置（单位：s），只有在有合法 src 时返回。（只读）

### boolean paused

当前是否暂停或停止。（只读）

### number buffered

音频已缓冲的时间，仅保证当前播放时间点到此时间点内容已缓冲。（只读）

## 方法

### [BackgroundAudioManager.play()](BackgroundAudioManager.play.html)

播放音乐

### [BackgroundAudioManager.pause()](BackgroundAudioManager.pause.html)

暂停音乐

### [BackgroundAudioManager.seek(number currentTime)](BackgroundAudioManager.seek.html)

跳转到指定位置

### [BackgroundAudioManager.stop()](BackgroundAudioManager.stop.html)

停止音乐

### [BackgroundAudioManager.onCanplay(function callback)](./BackgroundAudioManager.onCanplay.html)

监听背景音频进入可播放状态事件。 但不保证后面可以流畅播放

### [BackgroundAudioManager.onWaiting(function callback)](./BackgroundAudioManager.onWaiting.html)

监听音频加载中事件。当音频因为数据不足，需要停下来加载时会触发

### [BackgroundAudioManager.onError(function callback)](./BackgroundAudioManager.onError.html)

监听背景音频播放错误事件

### [BackgroundAudioManager.onPlay(function callback)](./BackgroundAudioManager.onPlay.html)

监听背景音频播放事件

### [BackgroundAudioManager.onPause(function callback)](./BackgroundAudioManager.onPause.html)

监听背景音频暂停事件

### [BackgroundAudioManager.onSeeking(function callback)](./BackgroundAudioManager.onSeeking.html)

监听背景音频开始跳转操作事件

### [BackgroundAudioManager.onSeeked(function callback)](./BackgroundAudioManager.onSeeked.html)

监听背景音频完成跳转操作事件

### [BackgroundAudioManager.onEnded(function callback)](./BackgroundAudioManager.onEnded.html)

监听背景音频自然播放结束事件

### [BackgroundAudioManager.onStop(function callback)](./BackgroundAudioManager.onStop.html)

监听背景音频停止事件

### [BackgroundAudioManager.onTimeUpdate(function callback)](./BackgroundAudioManager.onTimeUpdate.html)

监听背景音频播放进度更新事件，只有快应用在前台时会回调。

## 示例代码

```js
const backgroundAudioManager = qa.getBackgroundAudioManager()

backgroundAudioManager.title = '此时此刻'
backgroundAudioManager.epname = '此时此刻'
backgroundAudioManager.singer = '许巍'
backgroundAudioManager.coverImgUrl =
  'http://y.gtimg.cn/music/photo_new/T002R300x300M000003rsKF44GyaSk.jpg?max_age=2592000'
// 设置了 src 之后会自动播放
backgroundAudioManager.src =
  'http://ws.stream.qqmusic.qq.com/M500001VfvsJ21xFqb.mp3?guid=ffffffff82def4af4b12b3cd9337d5e7&uin=346897220&vkey=6292F51E1E384E061FF02C31F716658E5C81F5594D561F2E88B854E81CAAB7806D5E4F103E55D33C16F3FAC506D1AB172DE8600B37E43FAD&fromtag=46'
```
