# CanvasContext.createPattern(string image, string repetition)

对指定的图像创建模式的方法，可在指定的方向上重复元图像

## 参数

### string image

重复的图像源，仅支持包内路径和临时路径

### string repetition

如何重复图像

**repetition 的合法值**

| 值        | 说明               |
| --------- | ------------------ |
| repeat    | 水平竖直方向都重复 |  |
| repeat-x  | 水平方向重复       |  |
| repeat-y  | 竖直方向重复       |  |
| no-repeat | 不重复             |  |

## 示例代码

```js
const ctx = qa.createCanvasContext('myCanvas')
const pattern = ctx.createPattern('/path/to/image', 'repeat-x')
ctx.fillStyle = pattern
ctx.fillRect(0, 0, 300, 150)
ctx.draw()
```
